@extends('layouts.admin')

@section('title')
Profile
@endsection

@section('css')
<style>
    .btn {
    margin-right: 8px; /* Adjust the spacing as needed */
}
</style>
@endsection

@section('content')

    <div class="p-0">
        <div class="card">
            <div class="card-header ui-sortable-handle" style="cursor: move;">
                <h3 class="card-title"><i class="fas fa-users mr-1"></i>
                    Personal Detail
                </h3>
                <div class="card-tools">
                    <ul class="nav nav-pills ml-auto">
                        <li class="nav-item mr-1">
                            <a href="{{ route('personaldetail.create') }}" class="btn btn-sm btn-primary"><i class="fas fa-plus-circle"></i> Add New</a>
                            <a href="{{ route('exportUsers') }}" class='btn btn-sm  btn-flat btn-success' title='Export' id='SelectedRecord'> 
                              <i class='fa fa-file-excel-o' style='font-size:20px'></i> Export
                            </a>&nbsp;
                        </li>
                    </ul>
                </div>
            </div><!-- /.card-header -->
            

            <div class="card-body table-responsive table-bordered">
                <table class="table" id="example">
                    <thead>
                        <tr>
                        <th>Sr.No</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Mobile No</th>
                        <th>Status</th>
                        <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                      @foreach($personaldetail as $detail)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $detail->first_name .' '.$detail->last_name }} </td>
                            <td>{{ $detail->email }}</td>
                            <td>{{ $detail->mobile_no  }}</td>
                            <td>
                               @if($detail->status == 1)
                                <span class="badge badge-success"> {{ 'Verify'  }} <span>  
                               @elseif($detail->status == 2)
                                <span class="badge badge-danger">  {{ 'Reject'  }} <span>  
                               @else
                                <span class="badge badge-primary">  {{ 'Pending'  }} <span>  
                               @endif
                            </td>
                            <td>
                                <div class="btn-group">
                                    <a href="{{route('personaldetail.show',$detail->id)}}" title="Show" class="btn btn-flat btn-sm btn-info" > <i class="fa fa-eye"></i>  </a>
                                    <a href="{{route('personaldetail.edit',$detail->id)}}" title="Edit" class="btn btn-flat btn-sm btn-warning" > <i class="fa fa-edit"></i> </a>
                                    <button type="button" class="btn btn-flat btn-sm btn-danger" data-toggle="modal" data-target="#exampleModal" title="Delete"><i class="fas fa-trash-alt"></i> </button>
                                </div>
                                 <!-- Modal -->
                                    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                      <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                          <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Delete</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                              <span aria-hidden="true">&times;</span>
                                            </button>
                                          </div>
                                          <div class="modal-body">
                                           <form action="{{ route('personaldetail.destroy',$detail->id) }}" method="POST">
                                                @csrf
                                                @method('DELETE') 
                                               <p>Are you sure you want to delete?</p>
                                          
                                              <div class="modal-footer">
                                                <button type="submit" class="btn btn-danger">Delete</button>
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                              </div>
                                           </form>
                                          </div><!-- modal-body end-->
                                        </div>
                                      </div>
                                    </div>
                               <!-- Modal -->
                            </td>
                        </tr>
                         @endforeach 
                    </tbody>
                </table>
            </div>
            
            
        </div>
    </div>

@endsection


@section('js')
<script src="https://code.jquery.com/jquery-3.3.1.js"></script>
<script>
    $(document).ready(function () {
        $('#example').DataTable(); // Replace 'example' with the ID of your table
    });
</script>
@endsection
